@if ($fetchSetting->purchase_code)
    <div class="purchase-code-container d-flex align-items-center gap-2">
        <code class="blur-code purchase-code text-sm bg-light px-3 py-1 rounded">{{ $fetchSetting->purchase_code }}</code>

        <button type="button" class="btn btn-icon btn-light-secondary show-hide-purchase-code"
                data-toggle="tooltip" data-original-title="{{ __('messages.showHidePurchaseCode') }}">
            <i data-feather="eye" class="eye-icon hidden"></i>
            <i data-feather="eye-off" class="eye-slash-icon"></i>
        </button>

        <button type="button" class="btn btn-icon btn-light-primary verify-module"
                data-toggle="tooltip" data-original-title="{{ __('messages.changePurchaseCode') }}"
                data-module="{{ strtolower($module) }}">
            <i data-feather="edit-2"></i>
        </button>
    </div>
@else
    <button type="button" class="text-blue-600 hover:text-blue-800 underline inline-flex items-center verify-module" data-module="{{ strtolower($module) }}">
        <i data-feather="key" class="mr-2"></i>
        @lang('app.verifyEnvato')
    </button>
@endif
