<div>
    <div
        class="mx-4 p-4 mb-4 bg-white border border-gray-200 rounded-lg shadow-sm dark:border-gray-700 sm:p-6 dark:bg-gray-800">
        <h3 class="mb-4 text-xl font-semibold dark:text-white">@lang('modules.settings.restaurantInformation')</h3>
        <x-help-text class="mb-6">@lang('modules.settings.generalHelp')</x-help-text>

        <div class="grid grid-cols-2 gap-6">
            <div class="border border-gray-200 dark:border-gray-600 rounded-lg p-4">
                <form wire:submit="submitForm">
                    <div>
                        <div>
                            <x-label class="mt-4" for="restaurantName"
                                value="{{ __('modules.settings.restaurantName') }}" />
                            <x-input id="restaurantName" class="block mt-2 w-full" type="text"
                                placeholder="{{ __('placeholders.restaurantNamePlaceHolder') }}" autofocus
                                wire:model='restaurantName' />
                            <x-input-error for="restaurantName" class="mt-2" />
                        </div>

                        <div>
                            <x-label class="mt-4" for="restaurantPhoneNumber"
                                value="{{ __('modules.settings.restaurantPhoneNumber') }}" />
                            <x-input id="restaurantPhoneNumber" class="block mt-2 w-full" type="tel"
                                wire:model='restaurantPhoneNumber' />
                            <x-input-error for="restaurantPhoneNumber" class="mt-2" />
                        </div>

                        <div>
                            <x-label class="mt-4" for="restaurantEmailAddress"
                                value="{{ __('modules.settings.restaurantEmailAddress') }}" />
                            <x-input id="restaurantEmailAddress" class="block mt-2 w-full" type="email"
                                wire:model='restaurantEmailAddress' />
                            <x-input-error for="restaurantEmailAddress" class="mt-2" />
                        </div>

                        <div>
                            <x-label class="mt-4" for="restaurantAddress"
                                value="{{ __('modules.settings.restaurantAddress') }}" />
                            <x-textarea class="block mt-2 w-full" wire:model='restaurantAddress' rows='3' />
                            <x-input-error for="restaurantAddress" class="mt-2" />
                        </div>
                    </div>
                    <div class="col-span-2 mt-3">
                        <x-button>@lang('app.save')</x-button>
                    </div>
                </form>
            </div>

            <div class="border border-gray-200 dark:border-gray-600 rounded-lg p-4">
                <form wire:submit="submitTax" class="flex flex-col justify-between h-full">
                    <div class="rounded-lg p-4 flex-grow">
                        <div class="space-y-4">
                            <x-label for="showTax">
                                <div class="flex items-center cursor-pointer pb-4">
                                    <x-checkbox name="showTax" id="showTax" wire:model.live="showTax" />
                                    <div class="ms-2">
                                        @lang('modules.settings.showTax')
                                    </div>
                                </div>
                            </x-label>

                            @if ($showTax)
                                
                                @foreach ($taxFields as $index => $field)
                                    <div class="flex items-center gap-x-3 justify-between mb-2"
                                        wire:key="main-{{ $index }}">
                                        <div class="grid grid-cols-1 md:grid-cols-2 w-full gap-3"
                                            wire:key="data-{{ $index }}">
                                            <div>
                                                <x-label for="taxName{{ $index }}"
                                                    value=" {{ __('modules.settings.taxName') }}" />
                                                <x-input id="taxName{{ $index }}" class="block mt-1 w-full"
                                                    type="text" required
                                                    wire:model="taxFields.{{ $index }}.taxName" />
                                                <x-input-error for="taxFields.{{ $index }}.taxName"
                                                    class="mt-2" />
                                            </div>
                                            <div>
                                                <x-label for="taxId{{ $index }}"
                                                    value="{{ __('modules.settings.taxId') }}" />
                                                <x-input id="taxId{{ $index }}" class="block mt-1 w-full" required
                                                    type="text" wire:model="taxFields.{{ $index }}.taxId" />
                                                <x-input-error for="taxFields.{{ $index }}.taxId"
                                                    class="mt-2" />
                                            </div>
                                        </div>

                                        <x-secondary-button type="button"
                                            wire:click="showConfirmationField({{ $field['id'] ?? 'null' }}, {{ $index }})"
                                            class="mt-5 p-2 {{ $index > 0 ? 'visible' : 'invisible' }}">
                                            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                                                class="w-5 h-5 text-red-500">
                                                <path d="M10 11V17" stroke="currentColor" stroke-width="2"
                                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path d="M14 11V17" stroke="currentColor" stroke-width="2"
                                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path d="M4 7H20" stroke="currentColor" stroke-width="2"
                                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path
                                                    d="M6 7H12H18V18C18 19.6569 16.6569 21 15 21H9C7.34315 21 6 19.6569 6 18V7Z"
                                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                    stroke-linejoin="round"></path>
                                                <path
                                                    d="M9 5C9 3.89543 9.89543 3 11 3H13C14.1046 3 15 3.89543 15 5V7H9V5Z"
                                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                    stroke-linejoin="round"></path>
                                            </svg>
                                        </x-secondary-button>

                                    </div>
                                @endforeach
                                 <x-secondary-button type="button" class="m-2" wire:click="addMoreTaxFields" name="addMore">
                                    @lang('modules.settings.addMore')
                                </x-secondary-button>
                            @else
                                <div class="flex flex-col items-center justify-center p-6">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor"
                                        class="w-12 h-12 mt-5 text-gray-500">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M4.5 8.25h15m-15 0V19.5a2.25 2.25 0 002.25 2.25h10.5a2.25 2.25 0 002.25-2.25V8.25m-15 0l1.5-3.75A2.25 2.25 0 019 3.75h6a2.25 2.25 0 012.25 1.5l1.5 3.75M12 11.25v6.75m-3-3h6" />
                                    </svg>
                                    <p class="mt-4 text-lg text-center text-gray-500">
                                        @lang('modules.settings.noTaxFound')
                                </div>
                            @endif
                        </div>
                    </div>


                    <div class="flex justify-end mt-4 pt-4">

                        <x-button class="m-2">@lang('app.saveTax')</x-button>
                    </div>
                </form>
            </div>


        </div>

    </div>

    <x-confirmation-modal wire:model="confirmDeleteTaxModal">
        <x-slot name="title">
            @lang('modules.settings.deleteTax')?
        </x-slot>

        <x-slot name="content">
            @lang('modules.settings.deleteTaxMessage')
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmDeleteTaxModal')" wire:loading.attr="disabled">
                {{ __('Cancel') }}
            </x-secondary-button>

            <x-danger-button class="ml-3" wire:click="deleteAndRemove({{ $fieldId }} , {{ $fieldIndex }} )"
                wire:loading.attr="disabled">
                {{ __('Delete') }}
            </x-danger-button>
        </x-slot>
    </x-confirmation-modal>
</div>
